<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function lets_review_cb_ur() {
	$uid          = isset( $_POST['uid'] ) ? (int) $_POST['uid'] : 1;
	$is_pid       = isset( $_POST['isPid'] ) ? $_POST['isPid'] : '';
	$user100      = isset( $_POST['user100'] ) ? (int) $_POST['user100'] : false;
	$round        = 1;
	$cook         = isset( $_COOKIE['lr_block_rating'] ) ? json_decode( stripslashes( html_entity_decode( $_COOKIE['lr_block_rating'] ) ), true ) : array();
	$cook         = is_array( $cook ) ? $cook : array();
	$existing     = isset( $cook[ $uid ] ) ? (int) $cook[ $uid ]['outof100'] : false;
	$cook[ $uid ] = array(
		'uid'      => strval( $uid ),
		'outof100' => strval( $user100 ),
		'outof10'  => strval( $user100 / 10 ),
		'outof5'   => strval( number_format( ( $user100 / 20 ), 1 ) + 0 ),
	);
	Lets_Review_Options::lets_review_set_user_ratings();
	$user_ratings = Lets_Review_Options::$lets_review_options['lets_review_user_ratings'];
	if ( isset( $user_ratings[ $uid ] ) ) {
		$votes_cache = (int) $user_ratings[ $uid ]['votes'];
		$score_cache = (float) $user_ratings[ $uid ]['score']['outof100'];
		if ( false !== $existing ) {
			$round       = $existing > $score_cache ? 1 : 2;
			$score_cache = ( $score_cache * $votes_cache - $existing ) / max( ( $votes_cache - 1 ), 1 );
			$votes_cache--;
		}
	} else {
		$votes_cache = 0;
		$score_cache = 0;
	}
	$new_score = $user100;
	$new_votes = (int) $votes_cache + 1;
	$vote_txt  = sprintf( _n( 'Vote', 'Votes', $new_votes, 'lets-review' ), $new_votes );
	if ( 1 == $votes_cache ) {
		$new_score = ( ( $score_cache + $user100 ) / 2 );
	} elseif ( $votes_cache > 1 ) {
		$new_score = ( $score_cache * $votes_cache + $user100 ) / $new_votes;
	}
	$new_score = 1 == $round ? round( $new_score, 10, PHP_ROUND_HALF_UP ) : round( $new_score, 10, PHP_ROUND_HALF_DOWN );
	$new_score = $new_score > 100 ? 100 : $new_score;
	$new_score = $new_score < 0 ? 0 : $new_score;
	Lets_Review_Options::$lets_review_options['lets_review_user_ratings'][ $uid ] = array(
		'votes' => $new_votes,
		'score' => array(
			'outof100' => $new_score,
			'outof10'  => $new_score / 10,
			'outof5'   => number_format( ( $new_score / 20 ), 1 ) + 0,
		),
	);

	Lets_Review_Options::lets_review_update_option();

	if ( ! empty( $is_pid ) ) {
		update_post_meta( $uid, '_lets_review_user_rating_vote_count', (int) $new_votes );
		update_post_meta( $uid, '_lets_review_user_rating', (int) $new_score );
	}

	die(
		wp_json_encode(
			array(
				'user100New' => $new_score,
				'voteText'   => $new_votes . ' ' . $vote_txt,
				'cook'       => $cook,
			)
		)
	);
}

function lets_review_cb_ud() {
	$cid  = isset( $_POST['cid'] ) ? (int) $_POST['cid'] : '';
	$type = isset( $_POST['type'] ) && 'down' == $_POST['type'] ? 'down' : 'up';
	if ( empty( $cid ) ) {
		die();
	}
	$cook     = isset( $_COOKIE['lr_updown'] ) ? json_decode( stripslashes( html_entity_decode( $_COOKIE['lr_updown'] ) ), true ) : array();
	$cook     = is_array( $cook ) ? $cook : array();
	$existing = ! empty( $cook[ $cid ] ) ? $cook[ $cid ] : false;
	$up_downs = get_comment_meta( $cid, 'lets_review_ur_up_down', true );
	if ( ! empty( $up_downs ) ) {
		if ( false !== $existing ) {
			if ( 'up' == $type && 'up' == $existing || 'down' == $type && 'down' == $existing ) {
				if ( 'down' == $type ) {
					$down_new = (int) $up_downs['down'] - 1;
					$up_new   = $up_downs['up'];
				} else {
					$up_new   = (int) $up_downs['up'] - 1;
					$down_new = $up_downs['down'];
				}
				$unsetter = true;
			} else {
				if ( 'down' == $type ) {
					$down_new = (int) $up_downs['down'] + 1;
					$up_new   = $up_downs['up'] - 1;
				} else {
					$up_new   = (int) $up_downs['up'] + 1;
					$down_new = $up_downs['down'] - 1;
				}
			}
		} else {
			$up_new   = 'up' == $type ? (int) $up_downs['up'] + 1 : $up_downs['up'];
			$down_new = 'down' == $type ? (int) $up_downs['down'] + 1 : $up_downs['down'];
		}
	} else {
		$up_new   = 'up' == $type ? 1 : 0;
		$down_new = 'down' == $type ? 1 : 0;
	}
	$up_new   = $up_new < 0 ? 0 : $up_new;
	$down_new = $down_new < 0 ? 0 : $down_new;
	update_comment_meta(
		$cid,
		'lets_review_ur_up_down',
		array(
			'up'   => $up_new,
			'down' => $down_new,
		)
	);
	$cook[ $cid ] = $type;
	if ( ! empty( $unsetter ) ) {
		unset( $cook[ $cid ] );
	}
	die(
		wp_json_encode(
			array(
				'upNew'   => $up_new,
				'downNew' => $down_new,
				'cook'    => $cook,
			)
		)
	);
}

/**
 * Posts
 *
 * @since 3.0.0
*/
function lets_review_cb_posts( $request ) {

	$posts  = get_posts(
		array(
			'posts_per_page' => -1,
		)
	);
	$output = array();
	foreach ( $posts as $key ) {
		$output[] = array(
			'label' => $key->post_title,
			'value' => $key->ID,
		);
	}
	die( wp_json_encode( $output ) );
}

/**
 * Routes
 *
 * @since 3.0.0
*/
function lets_review_routes() {

	register_rest_route(
		'codetipi-lets-review/v3',
		'/ur',
		array(
			'methods'             => WP_REST_Server::EDITABLE,
			'callback'            => 'lets_review_cb_ur',
			'permission_callback' => '__return_true',
		)
	);

	register_rest_route(
		'codetipi-lets-review/v3',
		'/ud',
		array(
			'methods'             => WP_REST_Server::EDITABLE,
			'callback'            => 'lets_review_cb_ud',
			'permission_callback' => '__return_true',
		)
	);

	register_rest_route(
		'codetipi-lets-review/v3',
		'/posts',
		array(
			'methods'             => WP_REST_Server::READABLE,
			'callback'            => 'lets_review_cb_posts',
			'permission_callback' => '__return_true',
		)
	);

}
add_action( 'rest_api_init', 'lets_review_routes' );
